#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_PatientTransfusionRequirement : BaseTest 
	{
		private BOL.PatientTransfusionRequirement _tstPTRQ;
		private BOL.Patient _patient;

		private string _transfusionRequirementText;
		private Common.TransfusionRequirementCategoryCode _catCode;
		private Guid _patientGuid;

		private DataTable _dtPatientTransfusionRequirement;


		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtPatientTransfusionRequirement = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientTransfusionRequirement WHERE TransfusionRequirementCategoryCode = 'AS' AND RecordStatusCode = 'A' AND CreateDivisionCode = '" + this.TestDivisionCode + "'", true);

				_transfusionRequirementText	= this._dtPatientTransfusionRequirement.Rows[0][TABLES.PatientTransfusionRequirement.TransfusionRequirementText].ToString();

				_catCode = Common.Utility.GetTransfusionCategoryCodeFromString(_dtPatientTransfusionRequirement.Rows[0][TABLES.TransfusionRequirementCategory.TransfusionRequirementCategoryCode].ToString());
				
				_patientGuid = (System.Guid)this._dtPatientTransfusionRequirement.Rows[0][TABLES.Patient.PatientGuid];
			
				this.RefreshData = false;
			}
			_patient = new BOL.Patient(_patientGuid);

			_tstPTRQ = new gov.va.med.vbecs.BOL.PatientTransfusionRequirement(_patient, _transfusionRequirementText, _catCode, this.TestDivisionCode);
		}

		
		[Test]
		public void Ctor_Patient_String_Code_String_Pass()
		{
			_tstPTRQ = new BOL.PatientTransfusionRequirement(_patient, _transfusionRequirementText, _catCode, this.TestDivisionCode);
			Assert.IsTrue(_tstPTRQ != null);
			Assert.AreEqual(_tstPTRQ.TransfusionRequirementCategoryCode, this._catCode);
			Assert.AreEqual(_tstPTRQ.TransfusionRequirement, this._transfusionRequirementText);
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void Ctor_Patient_String_Code_String_Fail()
		{
			BOL.Patient patient = null;
			_tstPTRQ = new BOL.PatientTransfusionRequirement(patient, _transfusionRequirementText, _catCode, this.TestDivisionCode);
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			DataRow dtRow = this._dtPatientTransfusionRequirement.Rows[0];
			
			_tstPTRQ = new BOL.PatientTransfusionRequirement(dtRow);
			Assert.IsTrue(_tstPTRQ != null);
			
			if (dtRow.IsNull("TransfusionRequirementText") == false)
			{
				Assert.AreEqual( (string)dtRow["TransfusionRequirementText"], _tstPTRQ.TransfusionRequirement);
			}
			if (dtRow.IsNull("LastUpdateDate") == false)
			{
				
				Assert.AreEqual(_tstPTRQ.LastUpdateDate, (DateTime)dtRow["LastUpdateDate"]);
			}
		}
		[Test]
		public void Ctor_DataRow_Fail()
		{
			DataTable dt = BOL.PatientTransfusionRequirement.GetTransfusionRequirementsForPatient(Guid.Empty);
			Assert.IsTrue(dt.Rows.Count == 0);
		}

		[Test]
		public void TransfusionRequirementCategoryCode_Pass()
		{
			gov.va.med.vbecs.Common.TransfusionRequirementCategoryCode _TransfusionRequirementCategoryCode;
			_TransfusionRequirementCategoryCode = _tstPTRQ.TransfusionRequirementCategoryCode;
			Assert.AreEqual(_tstPTRQ.TransfusionRequirementCategoryCode,_TransfusionRequirementCategoryCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TransfusionRequirementCategoryCode_Fail()
		{
		}

		[Test]
		public void TransfusionRequirementGuid_Pass()
		{
			System.Guid _TransfusionRequirementGuid;
			_TransfusionRequirementGuid = _tstPTRQ.TransfusionRequirementGuid;
			Assert.AreEqual(_tstPTRQ.TransfusionRequirementGuid,_TransfusionRequirementGuid);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TransfusionRequirementGuid_Fail()
		{
		}

		[Test]
		public void TransfusionRequirement_Pass()
		{
			System.String _TransfusionRequirement;
			_TransfusionRequirement = _tstPTRQ.TransfusionRequirement;
			Assert.AreEqual(_tstPTRQ.TransfusionRequirement,_TransfusionRequirement);
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void TransfusionRequirement_Fail()
		{
			_tstPTRQ.TransfusionRequirement = String.Empty;
		}

		[Test]
		public void CreateDate_Pass()
		{
			System.DateTime _CreateDate;
			_CreateDate = _tstPTRQ.CreateDate;
			Assert.AreEqual(_tstPTRQ.CreateDate,_CreateDate);
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void CreateDate_Fail()
		{
			_tstPTRQ.CreateDate = DateTime.MinValue;
		}

		[Test]
		public void CreateUser_Pass()
		{
			System.String _CreateUser;
			_CreateUser = _tstPTRQ.CreateUser;
			Assert.AreEqual(_tstPTRQ.CreateUser,_CreateUser);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CreateUser_Fail()
		{
		}

		[Test]
		public void VistaConversionIndicator_Pass()
		{
			System.Boolean _VistaConversionIndicator;
			_VistaConversionIndicator = _tstPTRQ.VistaConversionIndicator;
			Assert.AreEqual(_tstPTRQ.VistaConversionIndicator,_VistaConversionIndicator);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void VistaConversionIndicator_Fail()
		{
		}

		[Test]
		public void AntibodyTypeID_Pass()
		{
			System.Int32 _AntibodyTypeID;
			_AntibodyTypeID = _tstPTRQ.AntibodyTypeId;
			Assert.AreEqual(_tstPTRQ.AntibodyTypeId,_AntibodyTypeID);
		}
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AntibodyTypeID_Fail()
		{
		}

		[Test]
		public void AntigenTypeID_Pass()
		{
			System.Int32 _AntigenTypeID;
			_AntigenTypeID = _tstPTRQ.AntibodyTypeId;
			Assert.AreEqual(_tstPTRQ.AntigenTypeId,_AntigenTypeID);
		}
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AntigenTypeID_Fail()
		{
		}

		[Test]
		public void ComponentRequirementID_Pass()
		{
			System.Int32 _ComponentRequirementID;
			_ComponentRequirementID = _tstPTRQ.AntibodyTypeId;
			Assert.AreEqual(_tstPTRQ.AntibodyTypeId,_ComponentRequirementID);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ComponentRequirementID_Fail()
		{
		}

		[Test]
		public void InactivationComment_Pass()
		{
			System.String _InactivationComment;
			_InactivationComment = _tstPTRQ.InactivationComment;
			Assert.AreEqual(_tstPTRQ.InactivationComment,_InactivationComment);
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void InactivationComment_Fail()
		{
			_tstPTRQ.InactivationComment = string.Empty;
		}

		[Test]
		public void InactivateDate_Pass()
		{
			System.DateTime _InactivateDate;
			_InactivateDate = _tstPTRQ.InactivateDate;
			Assert.AreEqual(_tstPTRQ.InactivateDate,_InactivateDate);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InactivateDate_Fail()
		{
		}

		[Test]
		public void InactivateUser_Pass()
		{
			System.String _InactivateUser;
			_InactivateUser = _tstPTRQ.InactivateUser;
			Assert.AreEqual(_tstPTRQ.InactivateUser,_InactivateUser);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InactivateUser_Fail()
		{
		}

		[Test]
		public void CreateDivisionCode_Pass()
		{
			System.String _CreateDivisionCode;
			_CreateDivisionCode = _tstPTRQ.CreateDivisionCode;
			Assert.AreEqual(_tstPTRQ.CreateDivisionCode,_CreateDivisionCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CreateDivisionCode_Fail()
		{
		}

		[Test]
		public void InactivateDivisionCode_Pass()
		{
			System.String _InactivateDivisionCode;
			_InactivateDivisionCode = _tstPTRQ.InactivateDivisionCode;
			Assert.AreEqual(_tstPTRQ.InactivateDivisionCode,_InactivateDivisionCode);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InactivateDivisionCode_Fail()
		{
		}


		[Test]
		public void RecordStatusCode_Pass()
		{
			gov.va.med.vbecs.Common.RecordStatusCode _RecordStatusCode;
			_RecordStatusCode = _tstPTRQ.RecordStatusCode;
			Assert.AreEqual(_tstPTRQ.RecordStatusCode,_RecordStatusCode);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}

		[Test]
		public void GetTransfusionRequirementsForPatient_Pass()
		{
			System.Guid patientGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PatientGuid FROM PatientTransfusionRequirement WHERE TransfusionRequirementCategoryCode = 'AS' AND PatientGuid IN (SELECT PatientGuid FROM Patient)");

			DataTable dt = BOL.PatientTransfusionRequirement.GetTransfusionRequirementsForPatient(patientGuid);
			Assert.IsTrue(dt.Rows.Count > 0);
		}

		[Test]
		public void GetTransfusionRequirementsForPatient_Pass2()
		{
			Guid TRGuid = Guid.NewGuid();
			Guid patientGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PatientGuid FROM PatientTransfusionRequirement WHERE TransfusionRequirementCategoryCode = 'AS' AND PatientGuid IN (SELECT PatientGuid FROM Patient)");
			
			string insertTransfusionReq = "INSERT INTO PATIENTTRANSFUSIONREQUIREMENT (";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.PatientGuid + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.TransfusionRequirementText + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateDate + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateUser + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateDivisionCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.VistaConversionIndicator + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.AntibodyTypeId + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.RecordStatusCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateDate + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateUser + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateFunctionId + ")";
			insertTransfusionReq += "VALUES (";
			insertTransfusionReq += "'" + TRGuid.ToString() + "',";
			insertTransfusionReq += "'" + patientGuid.ToString() + "',";
			insertTransfusionReq += "'Anti-C',";
			insertTransfusionReq += "'AS',";
			insertTransfusionReq += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReq += "'" + Environment.UserName + "',";
			insertTransfusionReq += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertTransfusionReq += "'1',";
			insertTransfusionReq += "'5',";
			insertTransfusionReq += "'C',";  //TR from conversion
			insertTransfusionReq += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReq += "'" + Environment.UserName + "',";
			insertTransfusionReq += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertTransfusionReq);

			DataTable dtTest = BOL.PatientTransfusionRequirement.GetTransfusionRequirementsForPatient(patientGuid);

			Assert.IsTrue(dtTest.Select(TABLES.PatientTransfusionRequirement.RecordStatusCode + " = 'C'").Length > 0);
		
			string deleteTRs = "DELETE FROM PATIENTTRANSFUSIONREQUIREMENT WHERE PatientTransfusionRequirementGuid = '" + TRGuid.ToString() + "'";

			UnitTestUtil.RunSQL(deleteTRs);
		}
		
		[Test]
		public void GetTransfusionRequirementsForPatient_Fail()
		{
			DataTable dt = BOL.PatientTransfusionRequirement.GetTransfusionRequirementsForPatient(Guid.Empty);
			Assert.IsTrue(dt.Rows.Count == 0);
		}

		[Test]
		public void InitializeSpecialInstructionsTable_Pass()
		{
			DataTable dt = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(true);
			foreach (DataColumn column in dt.Columns)
			{
				string columnName = column.ToString();
				if (
					columnName != TABLES.PatientTransfusionRequirement.AntibodyLastLocation &&
					columnName != TABLES.PatientTransfusionRequirement.AntibodyTypeId &&
					columnName != TABLES.PatientTransfusionRequirement.ComponentRequirementId &&
					columnName != TABLES.PatientTransfusionRequirement.CreateDate &&
					columnName != TABLES.PatientTransfusionRequirement.CreateDivisionCode &&
					columnName != TABLES.PatientTransfusionRequirement.CreateUser &&
					columnName != TABLES.PatientTransfusionRequirement.InactivateDate &&
					columnName != TABLES.PatientTransfusionRequirement.InactivateDivisionCode &&
					columnName != TABLES.PatientTransfusionRequirement.InactivateUser &&
					columnName != TABLES.PatientTransfusionRequirement.InactivationComment &&
					columnName != TABLES.PatientTransfusionRequirement.LastUpdateDate &&
					columnName == TABLES.PatientTransfusionRequirement.LastUpdateUser &&
					columnName == TABLES.PatientTransfusionRequirement.PatientGuid &&
					columnName == TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid &&
					columnName == TABLES.PatientTransfusionRequirement.RecordStatusCode &&
					columnName == TABLES.PatientTransfusionRequirement.RowVersion &&
					columnName == TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode &&
					columnName == TABLES.PatientTransfusionRequirement.TransfusionRequirementText &&
					columnName == TABLES.PatientTransfusionRequirement.VistaConversionIndicator
					)
				{
					Assert.Fail();
				}
			}
			Assert.IsTrue(true, "Yes!");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InitializeSpecialInstructionsTable_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr1 = new DataTable().NewRow();

			DataRow dr2 = this._tstPTRQ.LoadDataRowFromThis(dr1);

			Assert.AreEqual(dr1, dr2);				
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
			
		}

		[Test]
		public void SpecimenTestGuid_Pass()
		{
			System.Guid specimenTestGuid = Guid.NewGuid();
			//
			_tstPTRQ.SpecimenTestGuid = specimenTestGuid;
			//
			Assert.AreEqual( _tstPTRQ.SpecimenTestGuid, specimenTestGuid );
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenTestGuid_Fail()
		{
		}

		[Test]
		public void DoTransfusionRequirementsExistForPatient_Pass()
		{
			System.Guid patientGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PatientGuid FROM PatientTransfusionRequirement WHERE TransfusionRequirementCategoryCode = 'AS' AND RecordStatusCode IN ('A','C') AND PatientGuid IN (SELECT PatientGuid FROM Patient)");
			Assert.IsTrue( BOL.PatientTransfusionRequirement.DoTransfusionRequirementsExistForPatient( patientGuid ) );

			BOL.PatientTransfusionRequirement.DoTransfusionRequirementsExistForPatient(patientGuid);
		}

		[Test]
		public void DoTransfusionRequirementsExistForPatient_Fail()
		{
			string query = "SELECT TOP 1 P.patientguid FROM patient P WHERE (SELECT COUNT(*) FROM patienttransfusionrequirement WHERE patienttransfusionrequirement.patientguid = p.patientguid) < 1";
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( query.ToString() );
			//
			Guid patientGuid = (Guid) dr[TABLES.Patient.PatientGuid];
			//
			Assert.IsTrue( !BOL.PatientTransfusionRequirement.DoTransfusionRequirementsExistForPatient( patientGuid ) );
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void DoTransfusionRequirementsExistForPatient_InvalidArgument()
		{
			Assert.IsTrue( !BOL.PatientTransfusionRequirement.DoTransfusionRequirementsExistForPatient( Guid.Empty ) );
		}

		[Test]
		public void DoTransfusionRequirementsExistForPatient_TRsFromConversion_Pass()
		{
			System.Guid patientGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PatientGuid FROM PatientTransfusionRequirement WHERE TransfusionRequirementCategoryCode = 'AS' AND RecordStatusCode IN ('A','C') AND PatientGuid IN (SELECT PatientGuid FROM Patient)");
			string updateTRs = "UPDATE PatientTransfusionRequirement SET RecordStatusCode = 'C' WHERE PatientGuid = '" + patientGuid.ToString() + "'";
			UnitTestUtil.RunSQL(updateTRs);

			Assert.IsTrue( BOL.PatientTransfusionRequirement.DoTransfusionRequirementsExistForPatient( patientGuid ) );
		}
	}
}

#endif

